VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4605
   ClientLeft      =   3090
   ClientTop       =   2385
   ClientWidth     =   5700
   LinkTopic       =   "Form1"
   ScaleHeight     =   4605
   ScaleWidth      =   5700
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2640
      TabIndex        =   11
      Text            =   "0"
      Top             =   840
      Width           =   975
   End
   Begin VB.Frame Frame1 
      Caption         =   "Analog Output Ranges"
      Height          =   2175
      Left            =   480
      TabIndex        =   5
      Top             =   2040
      Width           =   2175
      Begin VB.OptionButton Option3 
         Caption         =   "0 - 5 VDC"
         Height          =   375
         Left            =   360
         TabIndex        =   8
         Top             =   1560
         Width           =   1095
      End
      Begin VB.OptionButton Option2 
         Caption         =   "+/- 5 VDC"
         Height          =   255
         Left            =   360
         TabIndex        =   7
         Top             =   960
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "+/- 10 VDC"
         Height          =   375
         Left            =   360
         TabIndex        =   6
         Top             =   360
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin VB.TextBox Text1 
      Height          =   375
      Left            =   2640
      TabIndex        =   3
      Text            =   "4.9998"
      Top             =   1440
      Width           =   855
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Write AO Chan 0"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1440
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   840
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   4560
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   4560
      Top             =   840
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label4 
      Caption         =   "Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2640
      TabIndex        =   12
      Top             =   600
      Width           =   1215
   End
   Begin VB.Label Label3 
      Caption         =   "DAC Counts:"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3000
      TabIndex        =   10
      Top             =   2760
      Width           =   735
   End
   Begin VB.Label lblCounts 
      BackColor       =   &H8000000E&
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3960
      TabIndex        =   9
      Top             =   2760
      Width           =   855
   End
   Begin VB.Label Label2 
      Caption         =   "volts"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3600
      TabIndex        =   4
      Top             =   1560
      Width           =   495
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   240
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this example was written for KPCI-3108 in Win2K SP1
' using VB6 and 3108-850A04 version of DriverLINX.
'
' it demonstrates how to use the ranges of the Analog Ouput of
' the KPCI-3108.  Default range is -10 to +10.  However, the
' DAC counts are really 0 to 65535 so it does not exactly map
' to +10 volts......more like one 16bit count shy of +10.

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpci3108$" ' the $ on end means load only the kpci3108 driver
.Req_device = devNum.ListIndex
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh

End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then  ' error check
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh  ' get new data about our device
Form1.Caption = "Analog Output Ranges of " & LDD.Dev_Model
Else
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()
On Error GoTo InRange
SetupAOSingleValue
' read in value to write to the DAC
Dim AOValue(0) As Single
Dim dummy As Long
AOValue(0) = CSng(Text1.Text)
dummy = SR.VBArrayBufferConvert(0, 0, 1, AOValue, DL_tSINGLE, 0, 0)
lblCounts.Caption = "&&H" & Right$("0000" & Hex(SR.Buf_0(0)), 4) ' write the DAC counts
SR.Refresh  ' do it
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
Exit Sub ' by pass the error handler

' for single value operations, normally the
' DLVolts2Code method would be used to convert
' volts to counts, but this method always assumes a bipolar gain of 1 was used.
' for data at other gains, use a single value buffer and the VBArrayBufferConvert
' method which is gain aware....... or factor in your gain yourself
InRange:
MsgBox "Please enter a valid number for the selected DAC range.", vbCritical
Text1.Text = "4.9998"
End Sub
Private Sub Form_Load()
' load the combo box with legal device numbers
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
devNum.ListIndex = 0
End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAOSingleValue()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_AO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 1                 ' one buffer used
.Sel_buf_samples = 1           ' only one sample
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = 0            ' is is channel 0
If Option1.Value = True Then
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
End If
If Option2.Value = True Then
.Sel_chan_startGainCode = .DLGain2Code(-2) ' negative = bipolar, 2 = gain of 2
End If
If Option3.Value = True Then
.Sel_chan_startGainCode = .DLGain2Code(2) ' positive = unipolar, 2 = gain of 2
End If
End With

End Sub
